/**HEADER********************************************************************
* 
* Copyright (c) 2010 Linear Tech Corporation;
* All Rights Reserved
*
* Copyright (c) 2008 Freescale Semiconductor;
* All Rights Reserved
*
* Copyright (c) 1989-2008 ARC International;
* All Rights Reserved
*
*************************************************************************** 
*
* THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESSED OR 
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
* IN NO EVENT SHALL FREESCALE OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
* INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
* STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
* IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
* THE POSSIBILITY OF SUCH DAMAGE.
*
**************************************************************************
*
* $FileName: ltctwrutils.c$
* $Version : 3.0.11.0$
* $Version : Custom for LTC Board Demo Suite
* $Date    : Sep-10-2010$
*
* Comments:
*
*   
*
*END************************************************************************/

//>>>>>>>>>>>>>>>>>>>>>>>>
//ltctwrutils.h
//ltctwrutils.c
//>>>>>>>>>>
//This file contains the utilities used by the demo system.
//Most importantly, it contains the initialization function to populate the LTCTWR_PARAMETER struct.
//It also has a function that will return the pointer to the local struct, so other tasks may use the data.
//Lastly, it contains a simple str2int function that will convert a string to an integer, useful for the demo.
//
//Warning: this implementation does not contain any safeguards to two tasks trying to edit the same struct.
//Care was taken to make sure only one task will write to the struct at any one given time.
//


#include "ltctwrutils.h"
#include <ltctwrboard.h>
#include <string.h>
#include <bsp.h>
#include <spi.h>
#include <mqx.h>

#if defined BSP_TWR_K60D100M

#define TEST_CHANNEL_POLLED "spi2:"
#define TEST_CHANNEL_INT    "ispi2:"

#if ! BSPCFG_ENABLE_SPI2
#error This application requires BSPCFG_ENABLE_SPI2 defined non-zero in user_config.h. Please recompile kernel with this option.
#endif

#else 

#define TEST_CHANNEL_POLLED "spi0:"
#define TEST_CHANNEL_INT    "ispi0:"

#if ! BSPCFG_ENABLE_SPI0
#error This application requires BSPCFG_ENABLE_SPI0 defined non-zero in user_config.h. Please recompile kernel with this option.
#endif

#endif


LTCTWR_PARAMS LTCTWR_Params = {0 };
#if defined BSP_TWR_K60D100M
DSPI_INIT_STRUCT _bsp_dspi2_init;
#else
MCF5XXX_QSPI_INIT_STRUCT _bsp_qspi0_init;
#endif


void LTCTWR_InitializeParameters(void) 
{

   //Populate the Struct
   _lwevent_create(&LTCTWR_Params.event, 0);
   LTCTWR_Params.chip = LTCTWR_1859;
   LTCTWR_Params.mode = READ;
   LTCTWR_Params.channel = 0;
   LTCTWR_Params.samplingperiod = 0;
   LTCTWR_Params.numsamples = 0;
   LTCTWR_Params.samplesize = 0;
   LTCTWR_Params.resultbuffer = NULL;

   //// SPECIAL REV D EDIT /////
#if defined BSP_TWR_K60D100M     
#if defined K60N512_REV_D
LTCTWR_PARAMS_PTR LTCTWR_Params_Ptr;   
#endif
#endif
  //// END SPECIAL REV D EDIT /////   

   //Set up the SPI controller and install init struct
#if defined BSP_TWR_K60D100M   
   setup_SPI ( (GPIO_PORT_D | GPIO_PIN11), 1000000, SPI_CLK_POL_PHA_MODE0, SPI_DEVICE_MASTER_MODE,	BSP_BUS_CLOCK, &_bsp_dspi2_init);
#else
   setup_SPI ( (GPIO_PORT_QS | GPIO_PIN5), 1000000, SPI_CLK_POL_PHA_MODE0, SPI_DEVICE_MASTER_MODE,	BSP_BUS_CLOCK, &_bsp_qspi0_init);   
#endif   
   
        //Changed it to Pin 4  (GPIO_PORT_QS | GPIO_PIN6)
    //(GPIO_PORT_AS | GPIO_PIN0)
    
    
   printf("\nTWR-ADCDAC-LTC Demonstration Suite\n\n"); 


   /* Open the SPI controller */        

#if defined BSP_TWR_K60D100M      
   LTCTWR_Params.spifd = fopen (TEST_CHANNEL_POLLED, NULL);
#else
   LTCTWR_Params.spifd = fopen ("ispi0:", NULL);   
#endif
 
   if (NULL == LTCTWR_Params.spifd) 
   {
      printf ("Failed to open the SPI driver, exiting ...\n");

   }

   change_SPI_endian(SPI_DEVICE_BIG_ENDIAN, LTCTWR_Params.spifd);
  
   
   //Set up the GPIO pins for the Decoder
   

#if defined BSP_TWR_K60D100M   
   if (! lwgpio_init(&LTCTWR_Params.decoderpins[0], (LWGPIO_PORT_E | LWGPIO_PIN27), 
   LWGPIO_DIR_OUTPUT, LWGPIO_VALUE_NOCHANGE))
   {
     printf ("Error in GPIO");
   }
   lwgpio_set_functionality(&LTCTWR_Params.decoderpins[0], 
                            LWGPIO_MUX_E27_GPIO);/*BSP_SPI_MUX_GPIO need define in BSP for function mux as GPIO*/
   lwgpio_set_value(&LTCTWR_Params.decoderpins[0], LWGPIO_VALUE_HIGH);
   
   
   if (! lwgpio_init(&LTCTWR_Params.decoderpins[1], (LWGPIO_PORT_E | LWGPIO_PIN5), 
   LWGPIO_DIR_OUTPUT, LWGPIO_VALUE_NOCHANGE))
   {
     printf ("Error in GPIO");
   }
   
   lwgpio_set_functionality(&LTCTWR_Params.decoderpins[1], 
                            LWGPIO_MUX_E5_GPIO);/*BSP_SPI_MUX_GPIO need define in BSP for function mux as GPIO*/
   lwgpio_set_value(&LTCTWR_Params.decoderpins[1], LWGPIO_VALUE_HIGH);
   
   
   if(!lwgpio_init(&LTCTWR_Params.decoderpins[2], (LWGPIO_PORT_C | LWGPIO_PIN19), 
   LWGPIO_DIR_OUTPUT, LWGPIO_VALUE_NOCHANGE))
   {
     printf ("Error in GPIO");
   }
   lwgpio_set_functionality(&LTCTWR_Params.decoderpins[2], 
                            LWGPIO_MUX_C19_GPIO);/*BSP_SPI_MUX_GPIO need define in BSP for function mux as GPIO*/
   lwgpio_set_value(&LTCTWR_Params.decoderpins[2], LWGPIO_VALUE_HIGH);
   
   
   //LTCTWR_Params.decoderpins[1] = (LWGPIO_PORT_E | LWGPIO_PIN5);
   //sLTCTWR_Params.decoderpins[2] = (LWGPIO_PORT_C | LWGPIO_PIN19);
#else
   LTCTWR_Params.decoderpins[0] = (LWGPIO_PORT_DD | LWGPIO_PIN6);   
   LTCTWR_Params.decoderpins[1] = (LWGPIO_PORT_DD | LWGPIO_PIN5);
   LTCTWR_Params.decoderpins[2] = (LWGPIO_PORT_UB | LWGPIO_PIN3);
#endif   
   //LTCTWR_Params.decoderpins[3] = {0};
   
  
////////////////SPECIAL REV D EDIT ////////////////////////////////
#if defined BSP_TWR_K60D100M     
#if defined K60N512_REV_D
   LTCTWR_Params_Ptr = LTCTWR_GetParameters();   
//LTCTWR_Params_Ptr->decoderpins[0] |= GPIO_PIN_STATUS_1; // bring GPIO7 high to bring Ethernet transceiver out of reset
//ioctl(LTCTWR_Params_Ptr->gpiofd, GPIO_IOCTL_WRITE, &LTCTWR_Params_Ptr->decoderpins );
   lwgpio_set_value(&LTCTWR_Params.decoderpins[0], LWGPIO_VALUE_HIGH);
   _time_delay(1000);	// allow time to bring Ethernet transceiver out of reset
#endif
#endif
////////////////END SPECIAL REV D EDIT ////////////////////////////////
   if (LTCTWR_Params.gpiofd == NULL)  printf("Opening file GPIO for muxpins failed.\n");
      
#if defined BSP_TWR_K60D100M      
   
   if (! lwgpio_init(&LTCTWR_Params.cspin[0], (LWGPIO_PORT_D | LWGPIO_PIN11), 
   LWGPIO_DIR_OUTPUT, LWGPIO_VALUE_NOCHANGE))
   {
     printf ("Error in GPIO");
   }
   lwgpio_set_functionality(&LTCTWR_Params.cspin[0], 
                            LWGPIO_MUX_D11_GPIO);/*BSP_SPI_MUX_GPIO need define in BSP for function mux as GPIO*/
   lwgpio_set_value(&LTCTWR_Params.cspin[0], LWGPIO_VALUE_HIGH);
   lwgpio_set_value(&LTCTWR_Params.decoderpins[1], LWGPIO_VALUE_HIGH);
   
   
   //LTCTWR_Params.cspin[0] = (LWGPIO_PORT_D | LWGPIO_PIN11);
#else
   //LTCTWR_Params.cspin[0] = (LWGPIO_PORT_QS | LWGPIO_PIN3);   
#endif   
   //LTCTWR_Params.cspin[1] = GPIO_LIST_END;
   
   //LTCTWR_Params.csfd = fopen("gpio:write", (char_ptr) &LTCTWR_Params.cspin);
   

}



LTCTWR_PARAMS_PTR  LTCTWR_GetParameters(void) 
{
   return &LTCTWR_Params;	
}


uint_32 str2int(char_ptr string) 
{
   int_8 i;
   uint_8 len, mask = 0x30;
   uint_32 pow[] = { 1, 10, 100, 1000, 10000, 100000, 1000000};
   uint_32 result = 0;
   
   len = strlen(string);
   for(i=0; i<len; i++) 
   {
   	  result += (((char*)string)[i] & ~mask)*pow[strlen(string)-1-i];
   }
   return result;
}


/* EOF */